/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK;
    private static final ForgeConfigSpec.IntValue MAGIC_NUMBER;
    public static final ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS;
    private static final ForgeConfigSpec.BooleanValue WEAK_POISON_HEALTH_OVERLAY;
    private static final ForgeConfigSpec.IntValue ANCIENT_BOAT_NEEDED_1_NUMBER;
    private static final ForgeConfigSpec.IntValue ANCIENT_BOAT_NEEDED_2_NUMBER;
    private static final ForgeConfigSpec.IntValue ANCIENT_CHEST_BOAT_NEEDED_1_NUMBER;
    private static final ForgeConfigSpec.IntValue ANCIENT_CHEST_BOAT_NEEDED_2_NUMBER;
    public static final ForgeConfigSpec.ConfigValue<String> POWER_BATTLE_MODE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> TERRACOTTA_GOLEM_SIDE_DECORATES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> REVERSE_NORMAL_EFFECT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> REVERSE_INSTANT_EFFECT;
    private static final ForgeConfigSpec.BooleanValue RIGHT_CLICK_HARVEST;
    private static final ForgeConfigSpec.BooleanValue POWER_BATTLE_MODE_HINT;
    private static final ForgeConfigSpec.BooleanValue POWER_BATTLE_MODE_STRENGTHEN_THE_ENEMIES;
    private static final ForgeConfigSpec.BooleanValue USE_DYNAMIC_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Float>> MAXIMUM_ATTACK_DAMAGE_MULTIPLIER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Float>> ATTACK_DAMAGE_MULTIPLIER_PER_HEALTH;
    private static final ForgeConfigSpec.BooleanValue USE_MIN_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Float>> MIN_DAMAGE;
    private static final ForgeConfigSpec.BooleanValue USE_HIGH_DAMAGE_COUNTERACTION;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Float>> MAXIMUM_DAMAGE_COUNTERACTION;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Float>> DAMAGE_COUNTERACTION_PER_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue MININ_PROBABILITY;
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static int ancientBoatNeeded_1;
    public static int ancientChestBoatNeeded_1;
    public static int ancientBoatNeeded_2;
    public static int ancientChestBoatNeeded_2;
    public static String magicNumberIntroduction;
    public static Set<Item> items;
    public static boolean rightClickHarvest;
    public static boolean powerBattleModeHint;
    public static boolean powerBattleModeStrengthenTheEnemies;
    public static boolean useDynamicDamage;
    public static List<Float> maximumAttackDamageMultiplier;
    public static List<Float> attackDamageMultiplierPerHealth;
    public static boolean useMinDamage;
    public static List<Float> minDamage;
    public static boolean useHighDamageCounteraction;
    public static List<Float> maximumDamageCounteraction;
    public static List<Float> damageCounteractionPerDamage;
    public static double mininProbability;
    public static boolean weakPoisonHealthOverlay;
    public static String powerBattleMode;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    public static List<Float> convertToListFloat(List<?> sourceList) {
        ArrayList<Float> targetList = new ArrayList<Float>();
        if (sourceList != null) {
            for (Object obj : sourceList) {
                if (obj instanceof Float) {
                    targetList.add((Float)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    targetList.add(Float.valueOf(((Double)obj).floatValue()));
                    continue;
                }
                if (!(obj instanceof Number)) continue;
                targetList.add(Float.valueOf(((Number)obj).floatValue()));
            }
        }
        return targetList;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        ancientBoatNeeded_1 = (Integer)ANCIENT_BOAT_NEEDED_1_NUMBER.get();
        ancientChestBoatNeeded_1 = (Integer)ANCIENT_CHEST_BOAT_NEEDED_1_NUMBER.get();
        ancientBoatNeeded_2 = (Integer)ANCIENT_BOAT_NEEDED_2_NUMBER.get();
        ancientChestBoatNeeded_2 = (Integer)ANCIENT_CHEST_BOAT_NEEDED_2_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
        weakPoisonHealthOverlay = (Boolean)WEAK_POISON_HEALTH_OVERLAY.get();
        powerBattleMode = (String)POWER_BATTLE_MODE.get();
        rightClickHarvest = (Boolean)RIGHT_CLICK_HARVEST.get();
        powerBattleModeHint = (Boolean)POWER_BATTLE_MODE_HINT.get();
        powerBattleModeStrengthenTheEnemies = (Boolean)POWER_BATTLE_MODE_STRENGTHEN_THE_ENEMIES.get();
        useDynamicDamage = (Boolean)USE_DYNAMIC_DAMAGE.get();
        maximumAttackDamageMultiplier = Config.convertToListFloat((List)MAXIMUM_ATTACK_DAMAGE_MULTIPLIER.get());
        attackDamageMultiplierPerHealth = Config.convertToListFloat((List)ATTACK_DAMAGE_MULTIPLIER_PER_HEALTH.get());
        useMinDamage = (Boolean)USE_MIN_DAMAGE.get();
        minDamage = Config.convertToListFloat((List)MIN_DAMAGE.get());
        useHighDamageCounteraction = (Boolean)USE_HIGH_DAMAGE_COUNTERACTION.get();
        maximumDamageCounteraction = Config.convertToListFloat((List)MAXIMUM_DAMAGE_COUNTERACTION.get());
        damageCounteractionPerDamage = Config.convertToListFloat((List)DAMAGE_COUNTERACTION_PER_DAMAGE.get());
        mininProbability = (Double)MININ_PROBABILITY.get();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        LOG_DIRT_BLOCK = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
        MAGIC_NUMBER = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
        MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
        ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
        WEAK_POISON_HEALTH_OVERLAY = BUILDER.comment("Whether to enable the health value display override for the weak potion effect").define("useWeakPoisonOverLay", true);
        ANCIENT_BOAT_NEEDED_1_NUMBER = BUILDER.comment("The number of #ancient_boat_need_1 that need to be held in hand to repair the ancient boat.").defineInRange("count of [ancient_boat_need_1]", 5, 0, Short.MAX_VALUE);
        ANCIENT_BOAT_NEEDED_2_NUMBER = BUILDER.comment("The number of #ancient_boat_need_2 that need to be held in hand to repair the ancient boat.").defineInRange("count of [ancient_boat_need_2]", 2, 0, Short.MAX_VALUE);
        ANCIENT_CHEST_BOAT_NEEDED_1_NUMBER = BUILDER.comment("The number of #ancient_chest_boat_need_1 that need to be held in hand to repair the ancient chest boat.").defineInRange("count of [ancient_chest_boat_need_1]", 5, 0, Short.MAX_VALUE);
        ANCIENT_CHEST_BOAT_NEEDED_2_NUMBER = BUILDER.comment("The number of #ancient_chest_boat_need_2 that need to be held in hand to repair the ancient chest boat.").defineInRange("count of [ancient_chest_boat_need_2]", 1, 0, Short.MAX_VALUE);
        POWER_BATTLE_MODE = BUILDER.comment(" ").comment("Greatly enhance effects and monsters. Use for that games using mods with additional cultivation content- such as Curios, any Skill mods or Guns mods.").comment("true: Always enabled this mode.").comment("default: Automatically determine whether to enable it based on the player's combat performance.").comment("false: Never enabled this mode.").define("powerBattleMode", (Object)"default");
        TERRACOTTA_GOLEM_SIDE_DECORATES = BUILDER.comment(" ").comment("A list of items that can use on side of terracotta golem.").comment("You can add other item to this list, it's texture must named be the same as item id.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
        RIGHT_CLICK_HARVEST = BUILDER.comment("After opening, you can right-click to harvest the crops of the module").define("rightClickHarvest", true);
        POWER_BATTLE_MODE_HINT = BUILDER.comment("After being turned off, when the Power Battle Mode is enabled, the prompt field will no longer be displayed in the game").define("powerBattleModeHint", true);
        POWER_BATTLE_MODE_STRENGTHEN_THE_ENEMIES = BUILDER.comment(" ").comment("We apologize for making players excessively capable. ").comment("For the sake of balance, you can use this option to synchronously strengthen some of the original enemies.").comment("Configure which enemies can be strengthened in the entity tags file, to all the functions.").define("needStrengthenTheEnemies", false);
        USE_DYNAMIC_DAMAGE = BUILDER.comment(" ").comment("Configure the attack damage multiplier of powered mobs be increased based on the target's health value").define("useDynamicDamage", false);
        MAXIMUM_ATTACK_DAMAGE_MULTIPLIER = BUILDER.comment(" ").comment("Set the maximum attack damage multiplier of powered mobs").comment("Example: [0.5, 2.0, 5.0],it must have 3 number,to normal mobs,elite mobs,mod bosses.").defineList("maximumDamageMultiplier", List.of(Float.valueOf(0.5f), Float.valueOf(2.0f), Float.valueOf(5.0f)), o -> o instanceof Float);
        ATTACK_DAMAGE_MULTIPLIER_PER_HEALTH = BUILDER.comment(" ").comment("Set the attack damage multiplier per target's health").comment("Example: [0.002, 0.006, 0.02],it must have 3 number,to normal mobs,elite mobs,mod bosses.").comment("Use gradient calculation. For example, for elite mobs, follow the default value:").comment(" the damage multiplier increases by 0.002 per health point until it reaches 1.5x (1+0.5), ").comment("then the damage multiplier increases by 0.006 per health point until it reaches 3.0x (1+2.0). ").defineList("damageMultiplierPerHealth", List.of(Float.valueOf(0.002f), Float.valueOf(0.006f), Float.valueOf(0.02f)), o -> o instanceof Float);
        USE_MIN_DAMAGE = BUILDER.comment(" ").comment("Configure the min value when powered mobs attack").define("useMinDamage", false);
        MIN_DAMAGE = BUILDER.comment(" ").comment("Set the min value when powered mobs attack").comment("Example: [1.0, 2.0, 2.5],it must have 3 number,to normal mobs,elite mobs,mod bosses.").defineList("minDamageValue", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(2.5f)), o -> o instanceof Float);
        USE_HIGH_DAMAGE_COUNTERACTION = BUILDER.comment(" ").comment("Configure the damage multiplier taken by mobs will decrease as the base damage value increases.").define("useHigh-DamageCounteraction", true);
        MAXIMUM_DAMAGE_COUNTERACTION = BUILDER.comment(" ").comment("Set the maximum damage divisor taken by mobs").comment("For example,if set 9.0 to a mob, damage taken by mobs will min become 0.1x.").comment("Example: [7.0, 11.0, 15.0],it must have 3 number,to normal mobs,elite mobs,mod bosses.").defineList("maximumDamageDivisor", List.of(Float.valueOf(7.0f), Float.valueOf(11.0f), Float.valueOf(15.0f)), o -> o instanceof Float);
        DAMAGE_COUNTERACTION_PER_DAMAGE = BUILDER.comment(" ").comment("Set the attack damage divisor per damage taken by mobs").comment("Example: [0.04, 0.05, 0.08],it must have 3 number,to normal mobs,elite mobs,mod bosses.").defineList("damageDivisorPerDamage", List.of(Float.valueOf(0.04f), Float.valueOf(0.05f), Float.valueOf(0.08f)), o -> o instanceof Float);
        MININ_PROBABILITY = BUILDER.comment("Set the probability of the sniffer beast mining Mod items").defineInRange("mininProbability", 0.5, 0.0, 1.0);
        BUILDER.push("ReverseNormalEffect").comment(new String[]{"Potion effects that can be reversed. Effect in this Map will be remove every tick. ", "It does not prevent the application of effects, so it may not completely block the activation of harmful potion effects sometimes if only use this.", "\"input-effect-n\" means ID of the effect to be converted,\"output-effect-n\" means ID of the effect that conversion result.", "Format: [[\"input-effect-1\", \"output-effect-1\"], [\"input-effect-2\", \"output-effect-2\"], ...etc]"});
        REVERSE_NORMAL_EFFECT = BUILDER.defineList("reverseNormalEffect", Arrays.asList(Arrays.asList("minecraft:bad_omen", "minecraft:hero_of_the_village"), Arrays.asList("minecraft:unluck", "minecraft:luck"), Arrays.asList("minecraft:glowing", "minecraft:invisibility"), Arrays.asList("minecraft:slowness", "minecraft:speed"), Arrays.asList("minecraft:levitation", "minecraft:slow_falling"), Arrays.asList("minecraft:darkness", "minecraft:conduit_power"), Arrays.asList("minecraft:mining_fatigue", "minecraft:haste"), Arrays.asList("minecraft:weakness", "minecraft:strength"), Arrays.asList("minecraft:poison", "immortalers_delight:lingering_infusion"), Arrays.asList("minecraft:hunger", "immortalers_delight:satiated"), Arrays.asList("minecraft:wither", "immortalers_delight:vitality"), Arrays.asList("minecraft:nausea", "farmersdelight:nourishment"), Arrays.asList("minecraft:blindness", "minecraft:night_vision"), Arrays.asList("immortalers_delight:weak_poison", "farmersdelight:comfort"), Arrays.asList("immortalers_delight:weak_wither", "minecraft:regeneration"), Arrays.asList("twilightforest:frosty", "immortalers_delight:cool"), Arrays.asList("aether:inebriation", "aether:remedy")), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof String);
        BUILDER.pop();
        BUILDER.push("ReverseInstantEffect").comment(new String[]{"It takes effect when the effect in this Map is being applied, blocking its application and reversing it.", "It only takes effect when the effect is being added, so it alone cannot convert existing effects.", "\"input-effect-n\" means ID of the effect to be converted,\"output-effect-n\" means ID of the effect that conversion result.", "Format: [[\"input-effect-1\", \"output-effect-1\"], [\"input-effect-2\", \"output-effect-2\"], ...etc]"});
        REVERSE_INSTANT_EFFECT = BUILDER.defineList("reverseInstantEffect", Arrays.asList(Arrays.asList("minecraft:instant_damage", "minecraft:instant_health"), Arrays.asList("minecraft:blindness", "minecraft:night_vision")), it -> it instanceof List && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

